% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_query_by_fulltitle}
\alias{epm_query_by_fulltitle}
\title{Query PubMed by Full-length Title.}
\usage{
epm_query_by_fulltitle(
  fulltitle,
  field = "[Title]",
  api_key = NULL,
  verbose = TRUE
)
}
\arguments{
\item{fulltitle}{String (character vector of length 1) that corresponds 
to the full-length publication title used for querying PubMed 
(titles should be used as is, without adding trailing filter tags).}

\item{field}{String (character vector of length 1). This indicates the 
PubMed record field where the full-length string (fulltitle) should be 
searched in. By default, this points to the 'Title' field. 
However, the field can be changed (always use fields supported by PubMed) as 
required by the user (for example, to attempt an exact-match query 
using a specific sentence included in the abstract of a record).}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be `NULL`.}

\item{verbose}{Logical, shall details about the 
progress of the operation be printed to console.}
}
\value{
an easyPubMed object.
}
\description{
Execute a PubMed query using a full-length 
publication title as query string. Tokenization and 
stopword removal is automatically performed. The goal is to mimic 
a Pubmed citation matching search. Because of this approach, 
it is possible that a query by full-length title may return 
more than one record.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  q <- 'Analysis of Mutational Signatures Using the mutSignatures R Library.'
  epm_query_by_fulltitle(q)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
