% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_query}
\alias{epm_query}
\title{Search for PubMed Records.}
\usage{
epm_query(query_string, api_key = NULL, verbose = TRUE)
}
\arguments{
\item{query_string}{String (character vector of length 1), 
corresponding to the query string.}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be `NULL`.}

\item{verbose}{logical, shall progress information be printed to console.
Defaults to `TRUE`.}
}
\value{
An easyPubMed object which includes no PubMed records.
}
\description{
Query PubMed (Entrez) via the PubMed API eSearch utility. 
Calling this function results in submitting a query to the NCBI EUtils 
server and then capturing and parsing the response.
The number of records expected to be returned by the query is 
determined. If this number is bigger than n=10,000, the record retrieval job 
is automatically split in a list of smaller manageable sub-queries. 
This function returns an "easyPubMed" object, which includes all
information required to retrieve PubMed records using the \code{epm_fetch()}
function.
}
\details{
This function will use "query_string" for querying PubMed. 
The Query Term can include one or multiple words, as well as the standard 
PubMed operators (AND, OR, NOT) and tags (i.e., [AU], [PDAT], 
[Affiliation], and so on).
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  qry <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  epm_query(query_string = qry, verbose = FALSE)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
