% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_detect_pmid}
\alias{EPM_detect_pmid}
\title{Detect PubMed Record Identifiers.}
\usage{
EPM_detect_pmid(x, format = "xml", as.list = TRUE)
}
\arguments{
\item{x}{list including PubMed record data (either in `xml` or 
`abstract` format).}

\item{format}{string (character of length 1) indicating the format of
each element in x (either `xml` or `medline`).}

\item{as.list}{logical (of length 1). Shall results be returned as a list.}
}
\value{
list of PubMed record identifiers.
}
\description{
Parse a list of pubmed records in XML or Medline format, 
extract and return the corresponding PubMed record identifiers (PMID).
}
\examples{
x <- list(A='First record: <PMID>Rec_1A</PMID> Lorem ipsum dolor sit amet', 
          B='Another record: <Ti>Title</Ti><PMID>Rec_2</PMID> Lorem ipsum ')
easyPubMed:::EPM_detect_pmid(x, format = 'xml')




}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
