% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eDNAjoint-package.R
\docType{package}
\name{eDNAjoint-package}
\alias{eDNAjoint-package}
\alias{eDNAjoint}
\title{The 'eDNAjoint' package.}
\description{
Models integrate environmental DNA (eDNA) detection data and
traditional survey data to jointly estimate species catch rate (see package
vignette: \url{https://ednajoint.netlify.app/}). Models can be used with count
data via traditional survey methods (i.e., trapping, electrofishing,
visual) and replicated eDNA detection/nondetection data via polymerase
chain reaction (i.e., PCR or qPCR) from multiple survey locations.
Estimated parameters include probability of a false positive eDNA
detection, a site-level covariates that scale the sensitivity of eDNA
surveys relative to traditional surveys, and catchability coefficients for
traditional gear types. Models are implemented with a Bayesian framework
(Markov chain Monte Carlo) using the 'Stan' probabilistic programming
language.
}
\references{
Stan Development Team (NA). RStan: the R interface to Stan.
https://mc-stan.org
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/eDNAjoint}
  \item \url{https://docs.ropensci.org/eDNAjoint/}
  \item Report bugs at \url{https://github.com/ropensci/eDNAjoint/issues}
}

}
\author{
\strong{Maintainer}: Abigail G. Keller \email{agkeller@berkeley.edu}

Other contributors:
\itemize{
  \item Ryan P. Kelly \email{rpkelly@uw.edu} [contributor]
  \item Chitra M. Saraswati [reviewer]
  \item Saras M. Windecker [reviewer]
}

}
