% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrGetDerivs.R
\name{theta_plot}
\alias{theta_plot}
\title{A function to plot simple slopes and region of significance.}
\usage{
theta_plot(.lm, predictor, moderator, alpha = 0.05, jn = F, title0,
  predictorLab, moderatorLab)
}
\arguments{
\item{.lm}{A regression object from running a linear model of the form: 
lm(y~ x1+x2+x1:x2), yielding: y = b0 + b1*x1 + b2*x2 + b3*x1*x2 + residual. 
In this case, one may rewrite the lm as y = b0 + (b1+b3*x2)*x1 + b2*x2 + residual,
where (b1+b3*x2) is referred to as the simple slope of x1, x1 is the predictor,
and x2 is the moderator whose values yield different simple slope values for x1.}

\item{predictor}{The independent variable for which simple slope is requested}

\item{moderator}{The moderator whose values affect the simple slopes of the predictor. 
Appears on the horizontal axis.}

\item{alpha}{The designated alpha level for the Johnson-Neyman technique}

\item{jn}{A binary flag requesting the Johnson-Neyman test (T or F)}

\item{title0}{Title for the plot}

\item{predictorLab}{Label for the predictor}

\item{moderatorLab}{Label for the moderator}
}
\value{
A region of significance plot with simple slopes of the predictor on
the vertical axis, and values of the moderator on the horizontal axis.
}
\description{
A function to plot simple slopes and region of significance.
}
\references{
Adapted from functions written by Marco Bachl to perform the Johnson-Neyman test 
and produce a plot of simple slopes and region of significance available at:
https://rpubs.com/bachl/jn-plot
}

