% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{multi_id_pivot_wider}
\alias{multi_id_pivot_wider}
\title{Transforming data.frame with Multiple Identifying columns into Wide Format}
\usage{
multi_id_pivot_wider(
  data,
  id,
  param_from,
  value_from,
  drop_na = FALSE,
  drop_lvl = FALSE
)
}
\arguments{
\item{data}{(\code{data.frame}) to be pivoted.}

\item{id}{(\code{character}) the name of the columns whose combination uniquely identify the observations.}

\item{param_from}{(\code{character}) the name of the column containing the names of the parameters to be pivoted. The
unique values in this column will become column names in the output.}

\item{value_from}{(\code{character}) the name of the column containing the values that will populate the output.}

\item{drop_na}{(\code{logical}) should column containing only \code{NAs} be dropped.}

\item{drop_lvl}{(\code{logical}) should missing levels be dropped in the columns coming from (\code{value_from}).}
}
\value{
\code{data.frame} in a wide format.
}
\description{
Transforming data.frame with Multiple Identifying columns into Wide Format
}
\details{
This function allows to identify observations on the basis of several columns. Warning: Instead of nesting
duplicated values, the function will throw an error if the same parameter is provided twice for the same
observation.
}
\examples{
test_data <- data.frame(
  the_obs = c("A", "A", "A", "B", "B", "B", "C", "D"),
  the_obs2 = c("Ax", "Ax", "Ax", "Bx", "Bx", "Bx", "Cx", "Dx"),
  the_param = c("weight", "height", "gender", "weight", "gender", "height", "height", "other"),
  the_val = c(65, 165, "M", 66, "F", 166, 155, TRUE)
)

multi_id_pivot_wider(test_data, c("the_obs", "the_obs2"), "the_param", "the_val")
multi_id_pivot_wider(test_data, "the_obs2", "the_param", "the_val")
}
