% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-rd.R, R/compute.R
\name{compute.duckplyr_df}
\alias{compute.duckplyr_df}
\title{Compute results}
\usage{
\method{compute}{duckplyr_df}(
  x,
  ...,
  prudence = NULL,
  name = NULL,
  schema_name = NULL,
  temporary = TRUE
)
}
\arguments{
\item{x}{A duckplyr frame.}

\item{...}{Arguments passed on to methods}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never,
\item \code{"thrifty"}: up to a maximum size of 1 million cells.
}

The default is to inherit from the input.
This argument is provided here only for convenience.
The same effect can be achieved by forwarding the output to \code{\link[=as_duckdb_tibble]{as_duckdb_tibble()}}
with the desired prudence.
See \code{vignette("prudence")} for more information.}

\item{name}{The name of the table to store the result in.}

\item{schema_name}{The schema to store the result in, defaults to the current schema.}

\item{temporary}{Set to \code{FALSE} to store the result in a permanent table.}
}
\value{
A duckplyr frame.
}
\description{
This is a method for the \code{\link[dplyr:compute]{dplyr::compute()}} generic.
For a duckplyr frame,
\code{compute()} executes a query but stores it in a (temporary) table,
or in a Parquet or CSV file.
The result is a duckplyr frame that can be used with subsequent dplyr verbs.
}
\examples{
library(duckplyr)
df <- duckdb_tibble(x = c(1, 2))
df <- mutate(df, y = 2)
explain(df)
df <- compute(df)
explain(df)
}
\seealso{
\code{\link[dplyr:compute]{dplyr::collect()}}
}
