% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AET01_table.R
\name{AET01_table}
\alias{AET01_table}
\title{Generate Core Safety Tables for Clinical Study Reports}
\usage{
AET01_table(
  adsl,
  adae,
  patient_var,
  treat_var,
  aesi_vars,
  aesi_heading = "Total number of patients with at least one",
  indent = "  "
)
}
\arguments{
\item{adsl}{A subject-level dataset (typically ADaM ADSL).}

\item{adae}{A dataset of adverse events, preprocessed with AESI flags.}

\item{patient_var}{A string indicating the subject identifier variable (e.g., \code{"USUBJID"}).}

\item{treat_var}{A string indicating the treatment arm variable (e.g., \code{"ARM"}).}

\item{aesi_vars}{A character vector of binary AESI flags in \code{adae}.}

\item{aesi_heading}{Optional character string used as a heading in the AESI block.}

\item{indent}{A string used to indent AESI row labels (default is 2 spaces).}
}
\value{
A merged \code{data.table} summarising the main safety outcomes.
}
\description{
\code{\link[=AET01_table]{AET01_table()}} produces and combines the main safety summary tables
typically found in Section 14.3.1 of a Clinical Study Report (CSR). It
calculates patient counts and event totals for deaths, AE-related
withdrawals, total AEs, and adverse events of special interest (AESIs).
}
\examples{
AET01_summary <- AET01_table(
  adsl = adsl,
  adae = aesi,
  patient_var = "USUBJID",
  treat_var = "ARM",
  aesi_vars = c("FATAL", "SER", "SERWD", "SERDSM", "RELSER",
                "WD", "DSM", "REL", "RELWD", "RELDSM", "SEV")
)
print(AET01_summary)

}
