% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcaNorm.R
\name{bcaNorm}
\alias{bcaNorm}
\title{Computer norm between two basic chance assignment objects}
\usage{
bcaNorm(x, y, p = 1)
}
\arguments{
\item{x}{A bca to evaluate norm.}

\item{y}{A bca to evaluate norm.}

\item{p}{exponent parameter of the norm}
}
\value{
a number of norm evaluation
}
\description{
Computer norm between two basic chance assignment objects
}
\examples{
y1 <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3, 
byrow = TRUE), m = c(0.2,0.5, 0.3),
cnames = c("a", "b", "c"),
varnames = "x", idvar = 1)
y2 <- bca(tt = matrix(c(1,0,0,1,1,1),nrow = 2, 
byrow = TRUE), m = c(0.6, 0.4),  
cnames = c("a", "b", "c"),  
varnames = "x", idvar = 1)
y1y2<-dsrwon(y1,y2)
bcaNorm(y1y2,y1)
}
\author{
Peiyuan Zhu
}
