% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{testPS}
\alias{testPS}
\title{Performs PS (parsimony score) test on switch data}
\usage{
testPS(
  switches,
  bylineage = FALSE,
  pseudocount = 0,
  alternative = c("less", "two.sided", "greater")
)
}
\arguments{
\item{switches}{Data frame from findSwitches}

\item{bylineage}{Perform test for each lineage individually? (FALSE)}

\item{pseudocount}{Pseudocount for P value calculations}

\item{alternative}{Perform one-sided (\code{greater} or \code{less})
or \code{two.sided} test}
}
\value{
A list containing a \code{tibble} with mean PS statistics, and another 
with PS statistics per repetition.
}
\description{
\code{testPS} performs a PS test
}
\details{
Output data table columns:
RECON = PS for observed data
PERMUTE = PS for permuted data
DELTA = RECON - PERMUTE
PLT = p value for DELTA < 0
PGT = p value for DELTA < 0
\itemize{
  \item  \code{RECON}: PS for observed data.
  \item  \code{PERMUTE}: PS for permuted data.
  \item  \code{DELTA}:  RECON - PERMUTE.
  \item  \code{PLT}: p value that DELTA < 0
  \item  \code{PGT}: p value that DELTA > 0
  \item  \code{STAT}: Statistic used (PS).
  \item  \code{REP}: Bootstrap repetition.
  \item  \code{REPS}: Total number of bootstrap repetition.
}
}
\examples{
\dontrun{
igphyml <- "~/apps/igphyml/src/igphyml"
data(ExampleAirr)
ExampleAirr$sample_id <- sample(ExampleAirr$sample_id)
clones <- formatClones(ExampleAirr, trait="sample_id")
btrees <- findSwitches(clones[1:2], bootstraps=10, nproc=1,
   igphyml=igphyml, trait="sample_id")
testPS(btrees$switches)
}
}
\seealso{
Uses output from \link{findSwitches}. Related to \link{testSP}
and \link{testSC}.
}
