% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_ci.R
\name{pseudo_score_ci}
\alias{pseudo_score_ci}
\title{Calculate pseudo score type confidence interval of DOOR probability}
\usage{
pseudo_score_ci(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  data_type = c("freq", "prop"),
  cil = 0.4,
  ciu = 0.6,
  conf_level = 0.95,
  epsilon = 1e-04,
  maxiter = 100
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{summary_obj}{A object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{cil, ciu}{Initial guesses of lower and upper limit, respectively}

\item{conf_level}{Confidence level}

\item{epsilon}{Convergence tolerance. Default to 1e-4}

\item{maxiter}{Maximum iteration}
}
\value{
pseudo-score type CI and the number of iterations to calculate the lower bound and
upper bound
}
\description{
Some code of this function is adpated from the now-archived CRAN package "cta",
originally authored by Joseph B. Lang. The original package was licensed under GPL-2,
and the adapted code complies with this license.
}
\examples{
pseudo_score_ci(c(60,30,10), c(50,40,10))
}
\seealso{
\code{\link[=door_ci]{door_ci()}}
}
