% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dllm.R
\name{dllm}
\alias{dllm}
\title{Fit a Dynamic Local Level Model (DLM)}
\usage{
dllm(
  data,
  obs_cols,
  S = c("univariate", "kvariate"),
  log10 = FALSE,
  date = NULL,
  prior = list(),
  equal.state.var = FALSE,
  equal.obs.var = FALSE,
  init_params = NULL,
  auto_init = TRUE,
  control = list(maxit = 500)
)
}
\arguments{
\item{data}{A data frame containing observed time series data.}

\item{obs_cols}{Character vector of column names in \code{data} to be used as observations.}

\item{S}{Character; the structure of latent states.}

\item{log10}{logical; if TRUE, a log10 transformation is applied to the whole data.}

\item{date}{Optional; the name of the column in \code{data} representing date or time.}

\item{prior}{A list of prior specifications. Default priors are used if not supplied.}

\item{equal.state.var}{logical; if TRUE the variance is the same across all wastewater state.}

\item{equal.obs.var}{logical; if TRUE the variance is the same across all wastewater observation.}

\item{init_params}{Optional numeric vector of initial parameters.}

\item{auto_init}{Logical; if \code{TRUE} (default) and \code{init_params} is \code{NULL}, initial parameters
are estimated automatically.}

\item{control}{List of control parameters for the optimization routine (\code{dlmMLE}).}
}
\value{
An object of class \code{dllm} containing the fitted model, filtered and smoothed estimates,
along with fit statistics (log-likelihood, AIC, BIC) and other diagnostic information.
\describe{
\item{data}{The input data.}
\item{date}{The input vector of date.}
\item{obs_cols}{Character vector of column names in \code{data} to be used as observations.}
\item{S}{Character; the structure of latent states.}
\item{parameters}{A list of estimated parameters by maximum likelihood estimation.}
\item{logLik}{The loglikelihood of the fitted model.}
\item{aic}{AIC of the fitted model.}
\item{bic}{BIC of the fitted model.}
\item{convergence}{An integer code returned by \code{\link{optim}}}
\item{model}{An \code{dlm} object of the fitted dynamic linear model. }
\item{filter}{The corresponding dynamic linear filter returned by \code{\link[dlm]{dlmFilter}}}
\item{smoother}{The corresponding dynamic linear smoother returned by \code{\link[dlm]{dlmSmooth}}}
\item{yf}{A matrix of the filtered observed response variables.}
\item{ys}{A matrix of the smoothed observed response variables.}}
}
\description{
Fits a dynamic linear model (DLM) using maximum likelihood estimation.
}
\details{
The function prepares the data, validates inputs, and (if necessary) automatically initializes parameters.
It then defines a helper function to build the model via \code{build_dlm} and fits the model using
maximum likelihood estimation (\code{dlmMLE}). Filtering and smoothing are applied to obtain state estimates.
}
\examples{
data<- wastewater[wastewater$Code == "TC",]
data$SampleDate <- as.Date(data$SampleDate)
fit <- dllm(
equal.state.var=TRUE,
equal.obs.var=FALSE,
log10=TRUE,
data = data,
date = "SampleDate",
obs_cols = c("ORFlab", "Nlab"),
S = 'kvariate')
summary(fit)
plot(fit, type='smoother', plot_data = TRUE)

}
