distfreereg.formula <-
  function(test_mean,
           ordering = "simplex",
           group = TRUE,
           stat = c("KS", "CvM"),
           B = 1e4,
           control = NULL,
           override = NULL,
           verbose = TRUE,
           ...,
           data,
           method,
           method_args = NULL
           # theta_init = NULL
           ){
    stopifnot(is(test_mean, "formula"))
    
    cl <- match.call()
    
    # To make sure the formula sent to lm is in this environment.
    environment(test_mean) <- environment()
    
    extra_arg_list <- list(...)
    
    vargs <- validate_args_distfreereg_formula(test_mean = test_mean,
                                               data = data,
                                               method = method,
                                               method_args = method_args,
                                               # theta_init = theta_init,
                                               override = override,
                                               verbose = verbose,
                                               extra_arg_list = extra_arg_list)

    n <- nrow(data)
    
    default_method_args <- list(formula = test_mean, data = data,
                                na.action = na.fail)
    
    # # If theta_init supplied, send that to glm() or nls(), but not lm().
    # if(!is.null(theta_init)){
    #   if("start" %in% names(formals(get(method)))){
    #     default_method_args[["start"]] <- theta_init
    #   } else {
    #     stop("theta_init must be NULL when selected model-fitting method does not have a 'start' argument")
    #   }
    # }
    method_args <- combine_lists(method_args, default_method_args)

    if(identical(method, "lm") || identical(method, "glm")){
      method_args[["x"]] <- TRUE
      method_args[["y"]] <- TRUE
    }
    
    m <- do.call(get(method), args = method_args)

    dfr_output <- distfreereg(test_mean = m,
                              ordering = ordering,
                              group = group,
                              stat = stat,
                              B = B,
                              control = control,
                              override = override,
                              verbose = verbose)
    
    output <- list(call = cl, test_mean = test_mean, model = m)
    output <- combine_lists(output, dfr_output)
    class(output) <- "distfreereg"
    
    return(output)
  }
