% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_decode.R
\name{json_encode_dir}
\alias{json_encode_dir}
\title{Encode a Directory to JSON}
\usage{
json_encode_dir(
  dir,
  type = c("text", "binary"),
  metadata = NULL,
  ignore = NULL
)
}
\arguments{
\item{dir}{A character string specifying the directory to encode.}

\item{type}{A character vector specifying the file types to include
(`text`, `binary`, or both). One or both of the following options:
  * `text`: Text files (e.g., `.txt`, `.csv`, `.json`).
  * `binary`: Binary files (e.g., `.bin`, `.exe`, `.jpg`).

Defaults to both.}

\item{metadata}{A character vector specifying additional metadata to
include in the JSON (`file_size`, `creation_time`,`last_modified_time`).  
One or both of the following options:
  * `file_size`: Size of the file in bytes.
  * `creation_time`: Creation time of the file.
  * `last_modified_time`: Last modified time of the file.

Defaults to `NULL.`}

\item{ignore}{A character vector specifying file names to exclude
from encoding. Defaults to `NULL.`}
}
\value{
A JSON string representing the directory's contents.
}
\description{
This function encodes all files in a directory into a JSON format.
}
\examples{
\dontrun{
# Encode all files in a directory to JSON
json_str <- json_encode_dir("mydir")

# Encode only text files, including file size metadata
json_str <- json_encode_dir("mydir", type = "text", metadata = "file_size")

# Ignore specific files
json_str <- json_encode_dir("mydir", ignore = c("ignore.txt"))
}
}
