% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_decode.R
\name{as_file_list}
\alias{as_file_list}
\title{Convert a File to a List}
\usage{
as_file_list(path, name = fs::path_file(path), type = NULL)
}
\arguments{
\item{path}{A character string specifying the file path.}

\item{name}{An optional character string specifying the file name.}

\item{type}{An optional character string specifying the file type ("text" or "binary").}
}
\value{
A structured list representing the file.
}
\description{
This function converts a file into a structured list for encoding.
}
\examples{
\dontrun{
# Convert a text file to a list
as_file_list("file.txt")

# Convert a binary file to a list
as_file_list("image.jpg", type = "binary")
}
}
