% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonplot.R
\name{seasonplot}
\alias{seasonplot}
\title{Creation of Seasonal Plots}
\usage{
seasonplot(
  x,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  labels = TRUE,
  colorpalette = NULL,
  rm_xticks = FALSE
)
}
\arguments{
\item{x}{a time series object of class \code{"ts"}.}

\item{xlab}{a label for the plot's x-axis.}

\item{ylab}{a label for the plot's y-axis.}

\item{main}{a title for the plot.}

\item{labels}{whether or not to show tick labels.}

\item{colorpalette}{a color palette (either a numeric or character vector) that 
gives an alternative color palette to use for the subseries.}

\item{rm_xticks}{whether to remove x-axis ticks and tick labels; the default is
\code{FALSE}.}
}
\value{
The function does not return anything, however a plot is created in the plot 
window.
}
\description{
Simplified seasonal plot creation of time series in order to identify 
seasonal patterns more easily.
}
\details{
The function creates a seasonal plot of the provided time series object. The
series is split into different subseries, each reflecting one season, and then 
these subseries are plotted together. This helps identifying possible seasonal
patterns in the data.
}
\examples{
seasonplot(TEMPERATURE, xlab = "Degrees Celsius", 
 main = "Seasonal plot of German temperature data")

}
