% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dd.plot.R
\name{dd.plot}
\alias{dd.plot}
\title{Depth-Depth Plots}
\usage{
dd.plot(data1, data2 = rmvnorm(nrow(data1), array(0, ncol(data1)), diag(1,
  ncol(data1), ncol(data1))), main = "Normal DD-plot",
  xlab = "Sample Depths", ylab = "Normal Depths", col = "black",
  pch = 20)
}
\arguments{
\item{data1}{A matrix or a data.frame with each row as a p-variate observation.}

\item{data2}{A matrix or a data.frame (defaults to a standard independent p-variate normal).}

\item{main}{Plot labels. The title of the plot.}

\item{xlab}{Plot labels. The \code{x-axis} label of the plot.}

\item{ylab}{Plot labels. The \code{y-axis} label of the plot.}

\item{col}{The color of the points}

\item{pch}{character string or vector of 1-characters or integers for plotting characters.}
}
\value{
A \code{DD-plot} of the input data
}
\description{
\code{dd.plot} is a multivariate genralization of a normal \code{QQ-plot}.
   It produces a DD-plot of two datasets.
}
\examples{
u<-matrix(rnorm(300,1,4),ncol=3)
dd.plot(u)

}
\author{
Somedip Karmakar <somedip@yahoo.co.in>

Omker Mahalanobish <omker.scorpio@gmail.com>
}
\seealso{
\code{\link{spatial.depth}}
}

