% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-custom_thresholds.R
\name{y_threshold}
\alias{y_threshold}
\alias{y_threshold<-}
\title{Get/set the Y threshold}
\usage{
y_threshold(plate)

y_threshold(plate) <- value
}
\arguments{
\item{plate}{A ddPCR plate.}

\item{value}{The new Y threshold}
}
\value{
The current Y threshold
}
\description{
For ddPCR plates of type \code{custom_thresholds}, get or set the threshold
along the Y axis that divides the droplet quadrants.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
y_threshold(plate)
y_threshold(plate) <- 8000
plot(plate)
}
}
\seealso{
\code{\link[ddpcr]{custom_thresholds}}\cr
\code{\link[ddpcr]{x_threshold}}\cr
\code{\link[ddpcr]{thresholds}}
}
