% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{c.haven_labelled_defined}
\alias{c.haven_labelled_defined}
\title{Combine defined vectors with metadata checks}
\usage{
\method{c}{haven_labelled_defined}(...)
}
\arguments{
\item{...}{One or more vectors created with \code{\link[=defined]{defined()}}.}
}
\value{
A single \code{defined} vector with concatenated values and retained
metadata.
}
\description{
The \code{c()} method for \code{defined} vectors ensures that all semantic metadata
(label, unit, concept, namespace, and value labels) match exactly. This
prevents accidental loss or mixing of incompatible definitions during
concatenation.
}
\details{
All input vectors must:
\itemize{
\item Have identical \code{label} attributes
\item Have identical \code{unit}, \code{concept}, and \code{namespace}
\item Have identical value labels (or none)
}
}
\examples{
a <- defined(1:3, label = "Length", unit = "meter")
b <- defined(4:6, label = "Length", unit = "meter")
c(a, b)

}
\seealso{
\code{\link[=defined]{defined()}}
}
