% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Clone}
\alias{Clone}
\title{Clone a tree (creates a deep copy)}
\usage{
Clone(node, pruneFun = NULL, attributes = FALSE)
}
\arguments{
\item{node}{the root node of the tree or sub-tree to clone}

\item{pruneFun}{allows providing a prune criteria, i.e. a function taking a \code{Node} as an input, and returning \code{TRUE} or \code{FALSE}. 
If the pruneFun returns FALSE for a Node, then the Node and its entire sub-tree will not be considered.}

\item{attributes}{if FALSE, then R class attributes (e.g. formatters and grViz styles)
are not cloned. This makes the method faster.}
}
\value{
the clone of the tree or sub-tree
}
\description{
The method also clones object attributes (such as the formatters), if desired.
If the method is called on a non-root, then the parent relationship is not cloned,
and the resulting \code{\link{Node}} will be a root.
}
\examples{
data(acme)
acmeClone <- Clone(acme)
acmeClone$name <- "New Acme"
# acmeClone does not point to the same reference object anymore:
acme$name

#cloning a subtree
data(acme)
itClone <- Clone(acme$IT)
itClone$isRoot


}
\seealso{
SetFormat
}
