% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerics.R
\name{num_info}
\alias{num_info}
\alias{num_info.default}
\alias{num_info.cvasi_simulate}
\alias{num_info.cvasi_fit}
\title{Print information about numerical solver result}
\usage{
num_info(obj)

\method{num_info}{default}(obj)

\method{num_info}{cvasi_simulate}(obj)

\method{num_info}{cvasi_fit}(obj)
}
\arguments{
\item{obj}{Return value of \code{\link[=simulate]{simulate()}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Prints information on the status of a return value from \code{\link[=simulate]{simulate()}}, e.g.
if it was successful and what, if any, issues occurred. Also provides tips
on solving frequently occurring issues.

The function requires certain metadata which is created by \code{\link[deSolve:ode]{deSolve::ode()}}
and is passed through to the result of \code{simulate()}. The metadata may be lost
if the \code{data.frame} returned by \code{simulate()} is converted or cast to other types.
}
\examples{
# A simulation without any issues
minnow_it \%>\% simulate() \%>\% num_info()

# A simulation which terminated early due to the solver
# taking too many numerical steps
rs <- suppressWarnings(minnow_it \%>\% simulate(hmax=1e-80))
num_info(rs)

# Print deSolve diagnostics for additional information
diagnostics(rs)
}
\seealso{
\code{\link[=diagnostics]{diagnostics()}}
}
