% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_exposure_functional_use}
\alias{get_exposure_functional_use}
\title{Retrieve exposure related functional use data}
\usage{
get_exposure_functional_use(
  DTXSID = NULL,
  API_key = NULL,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of functional use data.
}
\description{
Retrieve exposure related functional use data
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull functional use data for BPA
bpa <- get_exposure_functional_use(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
