% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Smix3}
\alias{Smix3}
\title{Survival function of 3-component discrete extreme value mixture distribution}
\usage{
Smix3(x, v, u, alpha1, theta1, alpha2, theta2, shape, sigma, phi1, phi2, phiu)
}
\arguments{
\item{x}{Vector of positive integers}

\item{v}{Positive integer representing the lower threshold}

\item{u}{Positive integer representing the upper threshold}

\item{alpha1}{Real number, first parameter of the Zipf-polylog component below v}

\item{theta1}{Real number in (0, 1], second parameter of the Zipf-polylog component below v}

\item{alpha2}{Real number, first parameter of the Zipf-polylog component between v & u}

\item{theta2}{Real number in (0, 1], second parameter of the Zipf-polylog component between v & u}

\item{shape}{Real number, shape parameter of the generalised Pareto component}

\item{sigma}{Real number, scale parameter of the generalised Pareto component}

\item{phi1}{Real number in (0, 1), proportion of values below v}

\item{phi2}{Real number in (0, 1), proportion of values between v & u}

\item{phiu}{Real number in (0, 1), exceedance rate of the threshold u}
}
\value{
A numeric vector of the same length as x
}
\description{
\code{Smix3} returns the survival function at x for the 3-component discrete extreme value mixture distribution. The component below v is the (truncated) Zipf-polylog(alpha1,theta1) distribution, between v & u the (truncated) Zipf-polylog(alpha2,theta2) distribution, and above u the generalised Pareto(shape, sigma) distribution.
}
\seealso{
\code{\link{dmix3}} for the corresponding probability mass function, \code{\link{Spol}} and \code{\link{Smix2}} for the survival functions of the Zipf-polylog and 2-component discrete extreme value mixture distributions, respectively.
}
