% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportionality.R
\name{logVarTaylorFull}
\alias{logVarTaylorFull}
\title{Full logp Variance-Covariance}
\usage{
logVarTaylorFull(
  mu,
  Sigma,
  transf = c("alr", "clr"),
  order = c("second", "first")
)
}
\arguments{
\item{mu}{The mean vector of the log-ratio-transformed data (ALR or CLR)}

\item{Sigma}{The variance-covariance matrix of the log-ratio-transformed data (ALR or CLR)}

\item{transf}{The desired transformation. If \code{transf="alr"} the inverse
additive log-ratio transformation is applied. If \code{transf="clr"} the
inverse centered log-ratio transformation is applied.}

\item{order}{The desired order of the Taylor Series approximation}
}
\value{
The estimated variance-covariance matrix for \code{log p}.
}
\description{
Estimates the variance-covariance of the log of the proportions using a
Taylor-series approximation.
}
\examples{
data(singlecell)
mle <- mleLR(singlecell)
mu <- mle$mu
Sigma <- mle$Sigma

logVarTaylorFull(mu, Sigma)

}
