% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{crf}
\alias{crf}
\title{Clustered random forest fitting}
\usage{
crf(
  formula,
  data,
  B = 500,
  L = 100,
  beta = 0.9,
  weight_optimiser = "Training MSE",
  correlation = "equicorr",
  maxdepth = 30,
  minbucket = 10,
  cp = 0,
  x0 = NULL,
  test_data = NULL,
  fixrho = FALSE,
  honesty = TRUE,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{formula}{an object of class `formula` describing the model to fit.}

\item{data}{training dataset for fitting the CRF. Note that group ID must be given by the column \code{id}.}

\item{B}{the total number of trees (or trees per little bag if \eqn{L\neq}`NULL`). Default is 500.}

\item{L}{the total number of little bags if providing a bootstrap of little bags estimate for inference. To not include set \eqn{L=}`NULL`. Default is `NULL`.}

\item{beta}{the subsampling rate. Default is \eqn{beta=0.9}.}

\item{weight_optimiser}{the method used to construct weights. Options are `Pointwise variance`, `Training MSE` or `Test MSE`. Default is `Training MSE`.}

\item{correlation}{the weight structure implemented. Currently supported options are `ar1` and `equicorr`. Default is `equicorr`.}

\item{maxdepth}{the maximum depth of the decision tree fitting. Default is 30.}

\item{minbucket}{the minbucket of the decision tree fitting. Default is 10.}

\item{cp}{the complexity paramter for decision tree fitting. Default is 0.}

\item{x0}{the covariate point to optimise weights towards if `weightoptimiser` set to `Pointwise variance`.}

\item{test_data}{the test dataset to optimise weights towards if `weightoptimiser` set to `Test MSE`.}

\item{fixrho}{fixes a pre-specified weight structure, given by the relevant `ar1` or `equicorr` parameter. Default is `FALSE` (optimise weights).}

\item{honesty}{whether honest or dishonest trees to be fit. Default is `TRUE`.}

\item{verbose}{Logical indicating whether or not to print computational progress. Default is `TRUE`.}

\item{seed}{Random seed for sampling. Default is NULL.}
}
\value{
A clustered random forest fitted object
}
\description{
Clustered random forest fitting
}
