% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/volume_methods.R
\name{upload_directory_cnt}
\alias{upload_directory_cnt}
\alias{upload_directory_cnt.ConnectorDatabricksVolume}
\title{Upload a directory}
\usage{
upload_directory_cnt(
  connector_object,
  src,
  dest,
  overwrite = zephyr::get_option("overwrite", "connector"),
  open = FALSE,
  ...
)

\method{upload_directory_cnt}{ConnectorDatabricksVolume}(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector"),
  open = FALSE,
  ...
)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{src}{\link{character} Path to the directory to upload}

\item{dest}{\link{character} The name of the new directory to place the content in}

\item{overwrite}{Overwrite existing content if it exists in the connector?
See \link[connector]{connector-options} for details. Default can be set globally with
\code{options(connector.overwrite = TRUE/FALSE)} or environment variable
\code{R_CONNECTOR_OVERWRITE}.. Default: \code{FALSE}.}

\item{open}{\link{logical} Open the directory as a new connector object.}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to
the \code{\link[brickster:db_volume_dir_create]{brickster::db_volume_dir_create()}} method}
}
\value{
\link{invisible} connector_object.
}
\description{
Additional list content methods for Databricks connectors implemented for
\code{\link[connector:upload_directory_cnt]{connector::upload_directory_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:upload_directory_cnt]{connector::upload_directory_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
