% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{center}
\alias{center}
\title{Dataset center}
\usage{
center(X, zero.rm = FALSE, na.rm = FALSE)
}
\arguments{
\item{X}{compositional dataset}

\item{zero.rm}{a logical value indicating whether zero values should be stripped
before the computation proceeds.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}
}
\description{
Generic function to calculate the center of a compositional dataset
}
\examples{
X = matrix(exp(rnorm(5*100)), nrow=100, ncol=5)
g = rep(c('a','b','c','d'), 25)
center(X)
(by_g <- by(X, g, center))
center(t(simplify2array(by_g)))
}
