% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{rand_vector_at_angle}
\alias{rand_vector_at_angle}
\title{Get a random unit vector at a given angle with another vector.}
\usage{
rand_vector_at_angle(u, angle)
}
\arguments{
\item{u}{Unit vector with \mjseqn{n} components.}

\item{angle}{Angle in radians.}
}
\value{
Random unit vector with \mjseqn{n} components which is at \code{angle}
radians with vector \code{u}.
}
\description{
\loadmathjax
Get a random unit vector which is at \code{angle} radians of vector \code{u}.
Note that \code{u} is expected to be a unit vector itself.
}
\note{
This function is stochastic. For reproducibility set a PRNG seed with
\link{set.seed}.
}
\examples{
u <- c(1.0, 0, 0.5, -0.5)            # Define a 4D vector
u <- u / norm(u, "2")                # Normalize the vector
v <- rand_vector_at_angle(u, pi / 4) # Get a vector at 45 degrees
arad <- acos((u \%*\% v) / norm(u,"2") * norm(v, "2")) # Get angle in radians
arad * 180 / pi # Convert to degrees, should be close to 45 degrees
}
