% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_transfer_bulk.R
\name{cloud_s3_write_bulk}
\alias{cloud_s3_write_bulk}
\title{Write multiple objects to S3 in bulk}
\usage{
cloud_s3_write_bulk(
  content,
  fun = NULL,
  ...,
  local = FALSE,
  quiet = FALSE,
  root = NULL
)
}
\arguments{
\item{content}{(data.frame) output of \code{cloud_object_ls()}}

\item{fun}{A custom writing function. If \code{NULL} (default), the appropriate
writing function will be inferred based on the file's extension.}

\item{...}{Additional arguments to pass to the writing function \code{fun}.}

\item{local}{Logical, defaulting to \code{FALSE}. If \code{TRUE}, the function will
also create a local copy of the file at the specified path. Note that some
writing functions might not overwrite existing files unless explicitly
allowed. Typically, such functions have a parameter (often named
\code{overwrite}) to control this behavior. Check the documentation of the
writing function used to determine the exact parameter name and pass it
through the \code{...} argument if necessary. Alternatively, you can define an
anonymous function for \code{fun} that calls a writing function with the
overwriting option enabled.}

\item{quiet}{all caution messages may be turned off by setting this parameter
to \code{TRUE}.}

\item{root}{S3 path of the project root. This serves as the reference point
for all relative paths. When left as \code{NULL}, the root is automatically
derived from the \code{cloudfs.s3} field of the project's DESCRIPTION file.}
}
\value{
Invisibly returns the input \code{content} dataframe.
}
\description{
This function allows for the bulk writing of multiple R objects
to the project's designated S3 folder. To prepare a list of objects for
writing, use \link{cloud_object_ls}, which generates a dataframe listing the
objects and their intended destinations in a format akin to the output of
\link{cloud_s3_ls}. By default, the function determines the appropriate writing
method based on each file's extension. However, if a specific writing
function is provided via the \code{fun} parameter, it will be applied to all
files, which may not be ideal if dealing with a variety of file types.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# write two csv files: data/df_mtcars.csv and data/df_iris.csv
cloud_object_ls(
  dplyr::lst(mtcars = mtcars, iris = iris),
  path = "data",
  extension = "csv",
  prefix = "df_"
) |>  
cloud_s3_write_bulk()
  
\dontshow{\}) # examplesIf}
}
