% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreProcessing.R
\name{proc.csv}
\alias{proc.csv}
\title{Processing CSV-Data}
\usage{
proc.csv(
  envrmt = .GlobalEnv$envrmt,
  method = "monthly",
  rbind = TRUE,
  save_output = TRUE,
  ...
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Either "daily", monthly" or "annual". Also depends on the available data.}

\item{rbind}{logical. Create a single file with all climate stations. If FALSE, every station will be saved in a seperate file.}

\item{save_output}{logical. If data should be saved permanently in the Environment put save_output = TRUE.
Otherwise the output will be saved in the temporary directory. Default: TRUE.}

\item{...}{arguments passed down from other functions.}
}
\value{
List
}
\description{
Calculate averaged sensor values aggregated to a given time interval.
}
\examples{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)
head(csv_data)

}
\seealso{
`prep.csv`, `spat.csv`, `fin.csv`
}
