% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_post_sql_runs}
\alias{scripts_post_sql_runs}
\title{Start a run}
\usage{
scripts_post_sql_runs(id)
}
\arguments{
\item{id}{integer required. The ID of the SQL job.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the run.}
\item{sqlId}{integer, The ID of the SQL job.}
\item{state}{string, The state of the run, one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{isCancelRequested}{boolean, True if run cancel requested, else false.}
\item{createdAt}{string, The time the run was created.}
\item{startedAt}{string, The time the run started at.}
\item{finishedAt}{string, The time the run completed.}
\item{error}{string, The error, if any, returned by the run.}
\item{output}{array, An array containing the following fields: 
\itemize{
\item outputName string, The name of the output file.
\item fileId integer, The unique ID of the output file.
\item path string, The temporary link to download this output file, valid for 36 hours.
}}
\item{outputCachedOn}{string, The time that the output was originally exported, if a cache entry was used by the run.}
}
\description{
Start a run
}
