% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_identifiers.R
\name{choice_identifiers}
\alias{choice_identifiers}
\alias{generate_choice_identifiers}
\alias{extract_choice_identifiers}
\title{Define choice identifiers}
\usage{
choice_identifiers(
  data_frame,
  format = "wide",
  column_decider = "deciderID",
  column_occasion = "occasionID",
  cross_section = FALSE
)

generate_choice_identifiers(
  N = length(Tp),
  Tp = 1,
  column_decider = "deciderID",
  column_occasion = "occasionID"
)

extract_choice_identifiers(
  x,
  format = attr(x, "format"),
  column_decider = attr(x, "column_decider"),
  column_occasion = attr(x, "column_occasion"),
  cross_section = attr(x, "cross_section")
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the choice identifiers.}

\item{format}{[\code{character(1)}]\cr
Either \code{"wide"} or \code{"long"}.

In the long case, unique combinations of \code{column_decider} and
\code{column_occasion} (if present) are used.}

\item{column_decider}{[\code{character(1)}]\cr
The name of the identifier column for deciders.}

\item{column_occasion}{[\code{character(1)} | \code{NULL}]\cr
The name of the identifier column for choice occasions (panel data).
Can be \code{NULL} for the cross-sectional case.}

\item{cross_section}{[\code{logical(1)}]\cr
Treat choice data as cross-sectional?}

\item{N}{[\code{integer(1)}]\cr
The number of deciders.}

\item{Tp}{[\code{integer(1)} | \code{integer(N)}]\cr
The number of choice occasions per decider.

Can also be of length \code{N} for a variable number of choice occasions per
decider.}

\item{x}{An object of class
\itemize{
\item \code{\link{choice_data}},
\item \code{\link{choice_covariates}}, containing the identifiers and covariate
values for each decider, occasion, and alternative,
}}
}
\value{
An object of class \code{choice_identifiers}, which is a \code{tibble} with columns:
\enumerate{
\item \code{column_decider} contains the decider identifiers,
\item \code{column_occasion} contains the choice occasion identifiers (only if
\code{column_occasion} is not \code{NULL} and \code{cross_section = FALSE}).
}
}
\description{
The \code{choice_identifiers} object defines identifiers for the deciders and
choice occasions.
\itemize{
\item \code{generate_choice_identifiers()} generates identifiers.
\item \code{extract_choice_identifiers()} extracts choice identifiers.
}
}
\examples{
### panel case
generate_choice_identifiers(N = 2, Tp = 2)

### cross-sectional case
generate_choice_identifiers(N = 5, column_occasion = NULL)

### read choice identifiers
choice_identifiers(
  data_frame = travel_mode_choice,
  format = "long",
  column_decider = "individual",
  column_occasion = NULL,
  cross_section = TRUE
)
}
\keyword{data}
