% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cell_message.R
\name{add_cell_message}
\alias{add_cell_message}
\title{Create a JavaScript cell message function for cheetahR widgets}
\usage{
add_cell_message(type = c("error", "warning", "info"), message = "message")
}
\arguments{
\item{type}{A string that specifies the type of message.
One of \code{"error"}, \code{"warning"}, or \code{"info"}. Default is \code{"error"}.}

\item{message}{A string or JS expression. If it contains \code{rec.}, \verb{?}, \code{:},
or a trailing \verb{;}, it is treated as raw JS (no additional quoting).
Otherwise, it is escaped and wrapped in single quotes.}
}
\value{
A \code{htmlwidgets::JS} object containing a JavaScript function definition:

\if{html}{\out{<div class="sourceCode js">}}\preformatted{function(rec) \{
  return \{
    type: "<type>",
    message: <message>
  \};
\}
}\if{html}{\out{</div>}}

Use this within \code{column_def()} for cell validation
}
\description{
Generates a JS function (wrapped with \code{htmlwidgets::JS}) that,
given a record (\code{rec}), returns an object with \code{type} and \code{message}.
}
\examples{
set.seed(123)
iris_rows <- sample(nrow(iris), 10)
data <- iris[iris_rows, ]

# Simple warning
cheetah(
  data,
  columns = list(
    Species = column_def(
      message = add_cell_message(type = "info", message = "Ok")
    )
  )
)

# Conditional error using `js_ifelse()`
cheetah(
  data,
  columns = list(
    Species = column_def(
      message = add_cell_message(
        message = js_ifelse(Species == "setosa", "", "Invalid")
      )
    )
  )
)

# Directly using a JS expression as string
cheetah(
  data,
  columns = list(
    Sepal.Width = column_def(
      style = list(textAlign = "left"),
      message = add_cell_message(
        type = "warning",
        message = "rec['Sepal.Width'] <= 3 ? 'NarrowSepal' : 'WideSepal';"
      )
    )
  )
)

}
