% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoid.R
\name{construct_geoid}
\alias{construct_geoid}
\title{Create GEOID from Default Columns}
\usage{
construct_geoid(
  .data,
  area_type,
  state = "state",
  county = "county",
  tract = "tract",
  block_group = "block group",
  block = "block",
  cd = "cd",
  shd = "shd",
  ssd = "ssd",
  zcta = "zcta"
)
}
\arguments{
\item{.data}{dataframe, tibble, or sf tibble}

\item{area_type}{Defaults to creating the smallest possible with 'spine'
for states, counties, tracts, block groups, and blocks. You can also pass
one of the on spine geographies to create that specific level. Other options are 'shd' for lower
state legislative districts, 'ssd' for upper state legislative districts, 'cd'
for congressional districts, or 'zcta' for zip code tabulation areas.}

\item{state}{name of column with state component}

\item{county}{name of column with county component}

\item{tract}{name of column with tract component}

\item{block_group}{name of column with block group component}

\item{block}{name of column with block component}

\item{cd}{name of column with cd component}

\item{shd}{name of column with shd component}

\item{ssd}{name of column with ssd component}

\item{zcta}{name of column with zcta component}
}
\value{
.data with new column GEOID
}
\description{
Create GEOID from Default Columns
}
\examples{
data(mt_county)
mt_county <- mt_county |> breakdown_geoid()
mt_county <- mt_county |> dplyr::select(-dplyr::all_of('GEOID'))
mt_county <- mt_county |> construct_geoid()
}
\concept{geoid}
