% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{get_palette}
\alias{get_palette}
\title{Create a palette for maps}
\usage{
get_palette(palette)
}
\arguments{
\item{palette}{The color palette to use.
Can be one of "alphabet", "arctic", "autumn", "autumn-muted", "bw", "desert", "evening", "gray", "iberia", "imhof", "lines", "metropolitan", "midnight", "minimal", "swiss", "tropical", or a named list for a custom palette.
If a named list is provided, it should contain color hex codes for each map element.
If \code{NULL} or an unrecognized name is provided, the function will throw an error.}
}
\value{
A list containing color settings for the map elements.
}
\description{
This function creates a color theme to be used with \code{plot_map()}. It can accept a predefined palette name or a custom palette provided as a named list.
}
\details{
The color moods for the predefined palettes are described as follows:
\itemize{
\item \strong{Alphabet}: A modern palette with a straightforward aesthetic.
\item \strong{Arctic}: A palette that reflects the clear and bright qualities of Arctic landscapes.
\item \strong{Autumn}: A palette with the warm and varied hues typical of the fall season.
\item \strong{BW}: A classic black and white palette with a hint of warmth for a traditional feel.
\item \strong{Evening}: A palette that embodies the quiet and contemplative nature of dusk.
\item \strong{Gray}: A balanced palette that provides a composed and refined look.
\item \strong{Iberia}: A palette that reflects the warm and diverse tones associated with the Iberian landscape.
\item \strong{Imhof}: A palette with natural and subdued tones, inspired by the work of cartographer Eduard Imhof.
\item \strong{Lines (BW)}: A contrasting black and white palette for a clear and defined appearance.
\item \strong{Metropolitan}: A palette with understated tones that suggest urban sophistication.
\item \strong{Midnight}: A palette that conveys the depth and tranquility of the night.
\item \strong{Minimal}: A palette focused on minimalism, utilizing primarily whites and light grays.
\item \strong{Serene}: A palette that embodies peace and simplicity, utilizing a soft color scheme with gentle contrasts.
\item \strong{Swiss}: A palette that emphasizes cleanliness and precision, reminiscent of Swiss design.
\item \strong{Tropical}: A lively palette with the bright and bold colors characteristic of tropical areas.
}

In addition, you can customize other settings:
\itemize{
\item \code{border_color}: The color of the borders, set to a dark shade "#121212".
\item \code{border_width}: The width of the borders, set to a very fine line of 0.001 units.
\item \code{linewidth_buildings}: The line width for building outlines, set to 0.05 units.
\item \code{linewidth_motorway}, \code{linewidth_trunk}, \code{linewidth_primary}, \code{linewidth_secondary}, \code{linewidth_tertiary}, \code{linewidth_unclassified}, \code{linewidth_residential}: The line widths for various types of roads, ranging from 6 units for motorways to 1 unit for pedestrian paths.
\item \code{size_streetlamp}: The size representation for streetlamps, set to 0.2 units.
\item \verb{hatch_*}: A series of settings for hatching patterns, which can be applied to water, buildings, and green spaces. These include toggles for hatching (\code{hatch_water}, \code{hatch_buildings}, \code{hatch_green}), the number of points or lines (\verb{hatch_*_npoints}, \verb{hatch_*_nlines}), the type of hatching pattern (\verb{hatch_*_type}), the size of the hatching elements (\verb{hatch_*_size}), and the transparency level (\verb{hatch_*_alpha}).
}

These settings allow for a high degree of customization when creating maps, providing users with the ability to fine-tune the appearance of their map elements according to their specific needs or preferences.
}
\examples{
# Use predefined palette
get_palette("imhof")

# Custom palette creation using a named list for a simple black and white palette
custom_palette <- list(
  palette_building = c("#000000", "#FFFFFF", "#CCCCCC"),
  water = "#000000",
  green = "#FFFFFF",
  beach = "#000000",
  parking = "#FFFFFF",
  street = "#000000",
  background = "#CCCCCC",
  railway = "#000000",
  hatch_water = TRUE,
  linewidth_buildings = 0.05,
  linewidth_motorway = 6,
  linewidth_primary = 4,
  linewidth_secondary = 4,
  linewidth_tertiary=3,
  linewidth_unclassified = 3,
  linewidth_residential = 3,
  linewidth_pedestrian = 1,
  linewidth_service = 1,
  linewidth_living_street = 1,
  size_hatch = 1,
  alpha_hatch = 0.1,
  size_streetlamp = 0.2
)

get_palette(custom_palette)
}
