% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_ard.R
\name{.derive_overall_labels}
\alias{.derive_overall_labels}
\title{Derive overall labels}
\usage{
.derive_overall_labels(x, cur_col = dplyr::cur_column())
}
\arguments{
\item{x}{(character) content of target (current) column}

\item{cur_col}{(character) name of current column}
}
\value{
a character vector
}
\description{
Transform the \code{"..cards_overall.."} and \code{"..hierarchical_overall.."} labels
into \code{"Overall <variable_name>"} and \code{"Any <variable_name>"} respectively.
Also it ensures the labels are unique (in case they already exist) with
\code{make.unique()} which appends a sequence number.
}
\examples{
data <- dplyr::tibble(
  ARM = c("..cards_overall..", "Overall ARM", NA, "BB", NA),
  TRTA = c(NA, NA, "..hierarchical_overall..", "C", "C")
)

data |>
  dplyr::mutate(
    dplyr::across(
      ARM:TRTA,
      cards:::.derive_overall_labels
    )
  )
}
\keyword{internal}
