% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modern_hindu.R, R/old_hindu.R
\name{hindu_solar_date}
\alias{hindu_solar_date}
\alias{hindu_lunar_date}
\alias{as_hindu_solar}
\alias{as_hindu_lunar}
\alias{old_hindu_solar_date}
\alias{old_hindu_lunar_date}
\alias{as_old_hindu_solar}
\alias{as_old_hindu_lunar}
\title{Hindu solar and lunar calendar dates}
\usage{
hindu_solar_date(year, month, day)

hindu_lunar_date(year, month, leap_month, day, leap_day)

as_hindu_solar(date)

as_hindu_lunar(date)

old_hindu_solar_date(year = integer(), month = integer(), day = integer())

old_hindu_lunar_date(
  year = integer(),
  month = integer(),
  leap_month = logical(),
  day = integer()
)

as_old_hindu_solar(date)

as_old_hindu_lunar(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{leap_month}{A logical vector indicating if year is a leap year}

\item{leap_day}{A logical vector indicating if day is a leap day}

\item{date}{A date vector on some calendar}
}
\value{
A vector object of Hindu dates.
}
\description{
There are four Hindu calendars implemented: modern Hindu solar and lunar calendars,
and the old Hindu solar and lunar calendars.
Hindu solar months are 1/12 of a solar year (approximately 30.44 days),
while lunar months are based on the lunar cycle (approximately 29.53 days).
}
\examples{
gregorian_date(2025, 1, 1:31) |>
  as_hindu_solar()
gregorian_date(2025, 1, 1:31) |>
  as_hindu_lunar()
}
\seealso{
\link{cal_hindu_solar}, \link{cal_hindu_lunar}, \link{cal_old_hindu_solar}, \link{cal_old_hindu_lunar}, \link{diwali}
}
