% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_bscui_styles.R
\name{update_bscui_styles}
\alias{update_bscui_styles}
\title{Update the style of bscui elements in 'shiny' app}
\usage{
update_bscui_styles(
  proxy,
  element_styles,
  to_ignore = NULL,
  targeted_tags = NULL,
  append = FALSE
)
}
\arguments{
\item{proxy}{a \code{\link{bscui_Proxy}} object}

\item{element_styles}{a data frame with an "id" column and
one column per style to apply. If the "id" column is missing, then the
modifications apply to the svg selected elements.}

\item{to_ignore}{of elements to ignore: if those elements are
children of elements to update they won't be updated. This parameter
is not taken into account when there is no "id" column in the element_styles
data frame.}

\item{targeted_tags}{affected tag names. If NULL (default),
the structure_shapes of the \code{\link{bscui}} object}

\item{append}{if TRUE the value will be concatenate with the existing value}
}
\value{
the provided proxy object
}
\description{
Update the style of bscui elements in 'shiny' app
}
\examples{
if(interactive()){
   from_shiny <- new.env()
   shiny::runApp(system.file(
      "examples", "shiny-anatomogram", package = "bscui"
   ))
   for(n in names(from_shiny)){
      bscui(from_shiny[[n]]) |> print()
   }
}
}
