% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_braid.R
\name{geom_braid_contour}
\alias{geom_braid_contour}
\alias{stat_braid_contour}
\title{Smoothed BRAID Surface Contours}
\usage{
geom_braid_contour(
  mapping = NULL,
  data = NULL,
  stat = "braid_contour",
  position = "identity",
  ...,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  npoints = 50,
  tight = FALSE,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_braid_contour(
  mapping = NULL,
  data = NULL,
  geom = "contour",
  position = "identity",
  ...,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  npoints = 50,
  tight = FALSE,
  trim = TRUE,
  shared = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{bins}{Number of contour bins. Overridden by \code{breaks}.}

\item{binwidth}{The width of the contour bins. Overridden by \code{bins}.}

\item{breaks}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}

\item{npoints}{The number of interpolated values in the x- and y- directions
that are used to generate the smoothed raster function}

\item{tight}{If true, the generated raster will span the precise range of
transformed and plotted data; this will produce a range of tiles that are
strictly smaller than those produced by \link{geom_braid} (as those tiles extend
above and below the plotted tile centers).  If \code{FALSE} (the default), the
interpolated values will be selected to span the same (slightly larger) range
of values that would be covered by running \link{geom_braid} with the same
parameters.}

\item{trim}{Should values that are finite in one dimension be dropped if
their finite coordinates lie outside the bounds of the main grid?}

\item{shared}{Should marginal offsets and trimming be calculated separately
for each facet if plots are faceted.  If \code{FALSE}, the default, each facet
will have its own bounds and marginal offsets; if \code{TRUE}, offsets will be
calculated for the full data and shared across all facets.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
Generate contours of a smoothed two-dimensional response surface
}
\details{
When evaluating a plotted response surface it is often more effective to
plot the precise contours at which a set of levels is reached by the
combination.  Because \link[ggplot2:geom_contour]{ggplot2::stat_contour} requires that data lie in an
evenly space raster grid (and does not support duplicated values), it is
difficult to apply to more discrete or irregularly sampled data.  This
function uses the same smoothing and interpolation utilities as
\link{geom_braid_smooth} to preprocess and smooth data, which is then passed to
the contour estimation code of \link[ggplot2:geom_contour]{ggplot2::stat_contour}, producing contours
which are smoothed and sufficiently regularly spaced.
}
\examples{
surface <- antagonisticExample

ggplot(surface,aes(x=concA,y=concB))+
   geom_braid_smooth(aes(fill=measure))+
   geom_braid_contour(aes(z=measure),colour="black",breaks=((1:9)/10))+
    scale_x_log10("Drug A")+
    scale_y_log10("Drug B")+
    scale_fill_distiller("Effect",palette="RdYlBu")+
    coord_equal()
}
