% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_alphabetical_calls_linter.R
\name{box_alphabetical_calls_linter}
\alias{box_alphabetical_calls_linter}
\title{\code{box} library alphabetical module and function imports linter}
\usage{
box_alphabetical_calls_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}.
}
\description{
Checks that module and function imports are sorted alphabetically. Aliases are
ignored. The sort check is on package/module names and attached function names.
}
\details{
Alphabetical sort order places upper-case/capital letters first: (A, B, C, a, b, c).

For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
lintr::lint(
  text = "box::use(packageB, packageA)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(package[functionB, functionA])",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(bslib, config, dplyr, DT)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/B, path/to/A)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/A[functionB, functionA])",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/A[alias = functionB, functionA])",
  linters = box_alphabetical_calls_linter()
)

# okay
lintr::lint(
  text = "box::use(packageA, packageB)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(package[functionA, functionB])",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(DT, bslib, config, dplyr)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/A, path/to/B)",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/A[functionA, functionB])",
  linters = box_alphabetical_calls_linter()
)

lintr::lint(
  text = "box::use(path/to/A[functionA, alias = functionB])",
  linters = box_alphabetical_calls_linter()
)

}
