% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json-support.R
\name{boilerplate_rds_to_json}
\alias{boilerplate_rds_to_json}
\title{Convert RDS Database to JSON}
\usage{
boilerplate_rds_to_json(
  input_path,
  output_path = NULL,
  pretty = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{input_path}{Path to RDS file or directory containing RDS files}

\item{output_path}{Path to save JSON files. If NULL, saves in same location
as input with .json extension.}

\item{pretty}{Pretty print JSON for readability? Default is TRUE.}

\item{quiet}{Suppress messages? Default is FALSE.}
}
\value{
Invisible TRUE on success
}
\description{
Utility function to convert existing RDS databases to JSON format. Can convert
a single file or batch convert all RDS files in a directory.
}
\details{
This function is useful for migrating existing RDS-based databases to the
more portable JSON format. JSON files are human-readable, work well with
version control, and can be used across different programming languages.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Create sample RDS file
sample_db <- list(methods = list(sampling = "Random sampling"))
saveRDS(sample_db, file.path(temp_dir, "methods_db.rds"))

# Convert single file
boilerplate_rds_to_json(file.path(temp_dir, "methods_db.rds"))

# Convert all RDS files in directory
boilerplate_rds_to_json(temp_dir)

# Convert to different location
output_dir <- tempfile()
dir.create(output_dir)
boilerplate_rds_to_json(temp_dir, output_path = output_dir)

# Clean up
unlink(temp_dir, recursive = TRUE)
unlink(output_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_migrate_to_json}} for full migration workflow
}
