% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-measures.R
\name{boilerplate_generate_measures}
\alias{boilerplate_generate_measures}
\title{Generate Formatted Text for Measures}
\usage{
boilerplate_generate_measures(
  variable_heading,
  variables,
  db,
  heading_level = 3,
  subheading_level = 4,
  print_waves = FALSE,
  print_keywords = FALSE,
  appendices_measures = NULL,
  label_mappings = NULL,
  quiet = FALSE,
  sample_items = FALSE,
  table_format = FALSE,
  check_completeness = FALSE,
  extract_scale_info = TRUE
)
}
\arguments{
\item{variable_heading}{Character. Heading for the variable section (e.g., "Exposure Variable", "Outcome Variables").}

\item{variables}{Character vector. Names of the variables to include.}

\item{db}{List. Measures database. Can be either a measures database or a unified database.
If a unified database is provided, the measures category will be extracted.}

\item{heading_level}{Integer. Heading level for the section header (e.g., 2 for ##, 3 for ###). Default is 3.}

\item{subheading_level}{Integer. Heading level for individual variables (e.g., 3 for ###, 4 for ####). Default is 4.}

\item{print_waves}{Logical. Whether to include wave information in the output. Default is FALSE.}

\item{print_keywords}{Logical. Whether to include keyword information in the output. Default is FALSE.}

\item{appendices_measures}{Character. Optional reference to appendices containing measure details.}

\item{label_mappings}{Named character vector. Mappings to transform variable names in the output.}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{sample_items}{Integer or FALSE. If numeric (1-3), shows only that many sample items. Default is FALSE (show all).}

\item{table_format}{Logical. If TRUE, formats output as markdown tables. Default is FALSE.}

\item{check_completeness}{Logical. If TRUE, adds notes about missing information. Default is FALSE.}

\item{extract_scale_info}{Logical. If TRUE, attempts to extract scale information from descriptions. Default is TRUE.}
}
\value{
Character string with formatted text describing the measures.
}
\description{
This function generates formatted markdown text describing measures in a study.
It creates a simple output with customisable heading levels, focusing on presenting
measure information in a clean, consistent format.
}
\examples{
# Create a temporary directory and initialise databases
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_measures_example", "data")

# Initialise measures database with default content
boilerplate_init(
  categories = "measures",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import the unified database
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)
measures_db <- unified_db$measures

# Generate with sample items only
exposure_text <- boilerplate_generate_measures(
  variable_heading = "Exposure Variable",
  variables = "anxiety",
  db = measures_db,
  sample_items = 2,  # Show only first 2 items
  quiet = TRUE
)

# Check the output
cat(substr(exposure_text, 1, 150), "...\n")

# Generate with table format for multiple variables
outcome_text <- boilerplate_generate_measures(
  variable_heading = "Outcome Variables",
  variables = c("anxiety", "depression"),
  db = measures_db,
  table_format = TRUE,
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_measures_example"), recursive = TRUE)

}
