% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{mixture3p_dist}
\alias{mixture3p_dist}
\alias{dmixture3p}
\alias{pmixture3p}
\alias{qmixture3p}
\alias{rmixture3p}
\title{Distribution functions for the three-parameter mixture model (mixture3p)}
\usage{
dmixture3p(
  x,
  mu = c(0, 2, -1.5),
  kappa = 5,
  p_mem = 0.6,
  p_nt = 0.2,
  log = FALSE
)

pmixture3p(q, mu = c(0, 2, -1.5), kappa = 5, p_mem = 0.6, p_nt = 0.2)

qmixture3p(p, mu = c(0, 2, -1.5), kappa = 5, p_mem = 0.6, p_nt = 0.2)

rmixture3p(n, mu = c(0, 2, -1.5), kappa = 5, p_mem = 0.6, p_nt = 0.2)
}
\arguments{
\item{x}{Vector of observed responses}

\item{mu}{Vector of locations. First value represents the location of the
target item and any additional values indicate the location of non-target
items.}

\item{kappa}{Vector of precision values}

\item{p_mem}{Vector of probabilities for memory recall}

\item{p_nt}{Vector of probabilities for swap errors}

\item{log}{Logical; if \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles}

\item{p}{Vector of probability}

\item{n}{Number of observations to generate data for}
}
\value{
\code{dmixture3p} gives the density of the three-parameter mixture model,
\code{pmixture3p} gives the cumulative distribution function of the
two-parameter mixture model, \code{qmixture3p} gives the quantile function of
the two-parameter mixture model, and \code{rmixture3p} gives the random
generation function for the two-parameter mixture model.
}
\description{
Density, distribution, and random generation functions for the
three-parameter mixture model with the location of \code{mu}, precision of
memory representations \code{kappa}, probability of recalling items from memory
\code{p_mem}, and probability of recalling non-targets \code{p_nt}.
}
\examples{
# generate random samples from the mixture3p model and overlay the density
r <- rmixture3p(10000, mu = c(0, 2, -1.5), kappa = 4, p_mem = 0.6, p_nt = 0.2)
x <- seq(-pi, pi, length.out = 10000)
d <- dmixture3p(x, mu = c(0, 2, -1.5), kappa = 4, p_mem = 0.6, p_nt = 0.2)
hist(r, breaks = 60, freq = FALSE)
lines(x, d, type = "l", col = "red")

}
\references{
Bays, P. M., Catalao, R. F. G., & Husain, M. (2009). The
precision of visual working memory is set by allocation of a shared
resource. Journal of Vision, 9(10), 7.
}
\keyword{distribution}
