% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mixture2p.R
\name{mixture2p}
\alias{mixture2p}
\title{Two-parameter mixture model by Zhang and Luck (2008).}
\usage{
mixture2p(resp_error, ...)
}
\arguments{
\item{resp_error}{The name of the variable in the provided dataset containing
the response error. The response Error should code the response relative to
the to-be-recalled target in radians. You can transform the response error
in degrees to radian using the \code{deg2rad} function.}

\item{...}{used internally for testing, ignore it}
}
\value{
An object of class \code{bmmodel}
}
\description{
Two-parameter mixture model by Zhang and Luck (2008).
}
\details{
\itemize{
\item \strong{Domain:} Visual working memory
\item \strong{Task:} Continuous reproduction
\item \strong{Name:} Two-parameter mixture model by Zhang and Luck (2008).
\item \strong{Citation:}
\itemize{
\item Zhang, W., & Luck, S. J. (2008). Discrete fixed-resolution representations in visual working memory. Nature, 453(7192), 233-235
}
\item \strong{Requirements:}
\itemize{
\item The response vairable should be in radians and represent the angular error relative to the target
}
\item \strong{Parameters:}
\itemize{
\item \code{mu1}: Location parameter of the von Mises distribution for memory responses (in radians). Fixed internally to 0 by default.
\item \code{kappa}: Concentration parameter of the von Mises distribution
\item \code{thetat}: Mixture weight for target responses
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{mu1} = 0
\item \code{mu2} = 0
\item \code{kappa2} = -100
}
\item \strong{Default parameter links:}
\itemize{
\item mu1 = tan_half; kappa = log; thetat = identity
}
\item \strong{Default priors:}
\itemize{
\item \code{mu1}:
\itemize{
\item \code{main}: student_t(1, 0, 1)
}
\item \code{kappa}:
\itemize{
\item \code{main}: normal(2, 1)
\item \code{effects}: normal(0, 1)
}
\item \code{thetat}:
\itemize{
\item \code{main}: logistic(0, 1)
}
}
}
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# generate artificial data
dat <- data.frame(y = rmixture2p(n = 2000))

# define formula
ff <- bmmformula(kappa ~ 1, thetat ~ 1)

model <- mixture2p(resp_error = "y")

# fit the model
fit <- bmm(
  formula = ff,
  data = dat,
  model = model,
  cores = 4,
  iter = 500,
  backend = "cmdstanr"
)
\dontshow{\}) # examplesIf}
}
\keyword{bmmodel}
