\encoding{UTF-8}

\name{nestedcontribution}
\alias{nestedcontribution}

\title{
Calculates the per-species contribution to nestedness (z-score relative to null model)
}

\description{
Estimates the degree to which the interactions of each row and column species increase or decrease community nestedness.
}

\usage{
nestedcontribution(web, nsimul = 99)
}

\arguments{
  \item{web}{A matrix with elements of a set (e.g., plants) as rows, elements of a second set (e.g., pollinators) as columns and number of interactions as entries. Non-binary matrices will be converted to 0/1 data.}
  \item{nsimul}{Number of randomizations to use as the basis for each comparison.}
}

\details{
The idea behind nestedness contribution is to determine how individual species' interactions change community nestedness compared to a random null model that is designed to control for the effect of differences in degree. For each row and column species, this function compares observed nestedness to an ensemble of nestedness values generated by randomizing the interactions of just that focal species. Nestedness contributions are the z-scores from this comparison. Therefore, a positive contributor to community nestedness (i.e., a species whose interactions increase overall nestedness) will obtain values greater than 0 and negative contributors to nestedness will obtain values less than 0.
}

\value{
For both the \dQuote{higher trophic level} and the \dQuote{lower trophic level}, this function returns a data frame with the per-species nestedness contributions.
}

\note{
This function calculates per-species nestedness contributions as described in Saavedra et al. 2011---namely it is based on the metric NODF to measure nestedness and employs a probabilistic null model to randomize interactions (that is described in Bascompte et al. 2003). The underlying methodology is amenable to other choices in both of these cases; however, this is not implemented at present.

The currently implemented null model replaces the observed vector of 0/1s by a probabalistic draw of 0/1s as given by the mean of mean degree in the higher trophic level (\code{rowSums(web)/ncol(web)}) and the mean degree for the target higher trophic level species i (\code{colSums(web)[i]/nrow(web)}).
}

\references{
Bascompte, J., Jordano, P., Melián, C.J., and Olesen, J.M. 2003. The nested assembly of plant-animal mutualistic networks. \emph{Proceedings of the National Academy of Sciences of the USA} \bold{100}, 9383--9387

Saavedra, S., Stouffer, D.B., Uzzi, B., and Bascompte, J. 2011. Strong contributors to network persistence are the most vulnerable to extinction. \emph{Nature} \bold{478}, 233--235
}

\author{
Daniel B. Stouffer \email{daniel.stouffer@canterbury.ac.nz}
}

% \seealso{
% \code{\link{nested}}; \code{\link{nestedrank}} is called by \code{\link{specieslevel}}
% }

\examples{
  data(Safariland)
  \dontrun{
    nestedcontribution(Safariland)
  }
}

\keyword{ package }
