% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doi2bib.R
\name{doi2bib}
\alias{doi2bib}
\title{Downloading bibliogrphic references from DOIs}
\usage{
doi2bib(x, ...)
}
\arguments{
\item{x}{A character vector including DOI identifiers.}

\item{...}{Further arguments (not yet used).}
}
\value{
The output is an object of class \linkS4class{lib_df}.
}
\description{
Retrieving bibliographic entries from Crossref by DOIs.
This function is a wrapper for \code{\link[rcrossref:cr_cn]{rcrossref::cr_cn()}}.
}
\examples{
## Retrieve bibliographic entries for two publications
dois <- c("10.1111/1748-5967.12330",
    "10.1016/j.envsci.2019.03.017")

bibrefs <- doi2bib(dois)
bibrefs
}
