% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaMethod-methods.R
\name{confint.deltamethod}
\alias{confint.deltamethod}
\title{Confidence Intervals}
\usage{
\method{confint}{deltamethod}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{deltamethod}.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals
}
\examples{
object <- glm(
  formula = vs ~ wt + disp,
  family = "binomial",
  data = mtcars
)
def <- list("exp(wt)", "exp(disp)")
out <- DeltaGeneric(
  object = object,
  def = def,
  alpha = 0.05
)
confint(out, level = 0.95)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
