% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popleaf.R
\name{popleaf}
\alias{popleaf}
\title{create leaflet popup box info}
\usage{
popleaf(
  df,
  sel = colnames(df),
  truncate = NULL,
  tstring = "[...]",
  exclude_geometry = TRUE,
  na.rm = FALSE
)
}
\arguments{
\item{df}{Data.frame}

\item{sel}{Columns to be selected (Names or index or TRUE/FALSE vector).
DEFAULT: colnames(df)}

\item{truncate}{Numeric: number of characters beyond which to truncate columns.
DEFAULT: NULL (no truncation)}

\item{tstring}{Charstring to add at the end if truncated. DEFAULT: "[...]"}

\item{exclude_geometry}{Remove column with the name "geometry" 
(as in sf objects) from the display? DEFAULT: TRUE}

\item{na.rm}{Exclude NA entries from the display? DEFAULT: FALSE}
}
\value{
Vector with character strings
}
\description{
combine data.frame columns into a leaflet popup-box compatible format
}
\examples{
dat <- data.frame(a=14:16, b=letters[14:16], c=LETTERS[14:16],
                 lat=c(52.58,53.45,52.4), lon=c(6.34,7.23,13.05))
popleaf(dat)
dat$display <- popleaf(dat, 1:4)

\dontrun{ # Excluded from CRAN checks
library(leaflet)
leaflet(dat) \%>\% addTiles() \%>\% addCircleMarkers(~lon, ~lat, popup=~display)
}

dat[1,1] <- "Very long string I'd rather have truncated"
popleaf(dat, 1:3)
popleaf(dat, 1:3, truncate=16)
popleaf(dat, 1:3, truncate=16, tstring="--")

}
\seealso{
\code{\link{paste}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2017
}
\keyword{aplot}
