% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{simpson}
\alias{simpson}
\alias{simpson_}
\title{Simpson's Measure of Concentration}
\usage{
simpson(.data = NULL, taxon, count)

simpson_(.data = NULL, taxon, count)
}
\arguments{
\item{.data}{data in a \code{data.frame}, \code{tibble}, 
\code{data.table}, database etc.}

\item{taxon}{name of column in \code{.data} containing taxa}

\item{count}{name of column in \code{.data} containing counts}
}
\value{
The probability that two individuals selected at random from a 
     sample will belong to the same species.
}
\description{
The probability that two individuals selected at random (with replacement, 
Hurlbert, 1971, p.579) from a sample will belong to the same species. For
an infinite sample Simpson's Index is given by (Peet, 1974):
\deqn{\lambda = \sum_{i=1}^S p_i^2}
For a finite sample by:
\deqn{L = \sum_{i=1}^S \frac{n_i (n_i-1)}{N (N-1)}}
where \eqn{p_i}{p[i]} the proportion of the individuals in species \eqn{i}, 
\eqn{n_i}{n[i]} the number of individuals in species 
\eqn{i} (relative \code{\link{abundance}}), and \eqn{N} the total number 
of individuals (\code{\link{total_abundance}}). The finite sample case 
has been implemented in function \code{simpson} (and \code{simpson_}).
}
\section{Functions}{
\itemize{
\item \code{simpson_()}: version suitable for calling from a function
(see package \pkg{lazyeval}).

}}
\examples{
     simpson(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"),  
         count = c(6, 12)
     )
 
}
\references{
Peet, R. K. 1974, The Measurement of Species Diversity. Annual 
     Review of Ecology and Systematics 5:285-307.
}
\seealso{
\code{\link{hpie}}
}
