% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{fitted.bbreg}
\alias{fitted.bbreg}
\title{fitted.bbreg}
\usage{
\method{fitted}{bbreg}(object, type = c("response", "link", "precision", "variance"), ...)
}
\arguments{
\item{object}{object of class "bbreg" containing results from the fitted model.}

\item{type}{the type of variable to get the fitted values. The default is the "response" type, which provided the estimated values for the means. The type "link" provides the estimates for the linear predictor of the mean. The type "precision" provides estimates for the precision parameters whereas the type "variance" provides estimates for the variances.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Function providing the fitted means for the model (bessel or beta).
}
\examples{
\donttest{
fit = bbreg(agreement ~ priming + eliciting, data = WT)
fitted(fit)
fitted(fit, type = "precision")}
}
\seealso{
\code{\link{predict.bbreg}}, \code{\link{summary.bbreg}}, \code{\link{coef.bbreg}}, \code{\link{vcov.bbreg}}, \code{\link{plot.bbreg}}
}
